#ifndef TYPES_H
#define TYPES_H


#define NOMINMAX /* This is needed for compatability of STL, or Standard 
	Template Library, with Windows. */

#include <windows.h>

#ifndef __BORLANDC__
#define __FLAT__ //Means 32 bit build, which is what Visual C++ always does
#endif //__BORLANDC__

typedef double Real;
#define PI 3.1415926


#define MIN(x,y) ((x)<=(y))?(x):(y)
#define ABS(x) ((x)>=0)?(x):(-(x))  //Handy macro so we don't need stdlib.h
#define CLAMP(x,lo,hi) (x)=(((x)<(lo))?(lo):(((x)>(hi))?(hi):(x)))

#define NDEBUG //Comment this line in to remove assert tests and speed up.
#include <assert.h>

#define SMALL_REAL 0.00001

#endif //TYPES_H
